using UnityEngine;

namespace PathTool
{

    public class Waypoint : MonoBehaviour
    {
        [Header("Waypoint Settings")]
        [SerializeField] private Vector3 forwardDirection = Vector3.forward;
        [SerializeField] private float activationAngleThreshold = 60f;

        public int index; // assegnato dal manager
        private WaypointsManager manager;

        private void Start()
        {
            manager = GetComponentInParent<WaypointsManager>();
        }

        public void SetActive(bool state)
        {
            gameObject.SetActive(state);
        }

        private void OnTriggerEnter(Collider other)
        {
            Debug.Log("Entrato");
            if (!manager) return;
            Debug.Log("Continua");
            if (!other.transform.root.CompareTag("Player")) return;
            Debug.Log("Continua 2");
            Vector3 playerForward = other.transform.forward;
            float angle = Vector3.Angle(forwardDirection.normalized, playerForward.normalized);

            if (angle <= activationAngleThreshold)
            {
                manager.WaypointReached(this);
            }
            else
            {
                Debug.Log("Waypoint NON preso nel verso corretto!");
            }
        }

        private void OnDrawGizmos()
        {
#if UNITY_EDITOR
            // disegna il cerchio
            Gizmos.color = Color.yellow;
            Gizmos.DrawWireSphere(transform.position, 0.5f);

            // disegna la direzione valida
            Gizmos.color = Color.green;
            Vector3 dir = transform.rotation * forwardDirection.normalized;
            Gizmos.DrawRay(transform.position, dir * 3f);


            // disegna etichetta numerica SEMPRE visibile
            UnityEditor.Handles.color = Color.white;
            UnityEditor.Handles.Label(transform.position + Vector3.up * 1.5f, $"Waypoint {index}");
#endif
        }
    }
}
