﻿using UnityEngine;
using UnityEditor;
using System.Collections.Generic;

namespace PathTool
{
    [CustomEditor(typeof(WaypointsManager))]
    public class WaypointsSystemEditor : Editor
    {
        public override void OnInspectorGUI()
        {
            DrawDefaultInspector();

            WaypointsManager system = (WaypointsManager)target; //cast della variabile "target", conversione

            if (GUILayout.Button("🔄 Rileva Waypoints (ordine progressivo)"))
            {
                Undo.RecordObject(system, "Rileva Waypoints");

                // Trova tutti i waypoint nei figli
                var found = new List<Waypoint>(system.GetComponentsInChildren<Waypoint>());
                if (found.Count == 0) return;

                List<Waypoint> ordered = new List<Waypoint>();

                // Punto di partenza: il più vicino al manager
                Transform origin = system.transform;
                Waypoint current = GetClosestWaypoint(origin.position, found);
                ordered.Add(current);
                found.Remove(current);

                // Ciclo fino a esaurimento
                while (found.Count > 0)
                {
                    current = GetClosestWaypoint(current.transform.position, found);
                    ordered.Add(current);
                    found.Remove(current);
                }

                // Aggiorna array
                system.waypoints = ordered.ToArray();

                // Aggiorna indici
                for (int i = 0; i < system.waypoints.Length; i++)
                {
                    system.waypoints[i].index = i;
                    EditorUtility.SetDirty(system.waypoints[i]);
                }
            }
        }

        private Waypoint GetClosestWaypoint(Vector3 from, List<Waypoint> list)
        {
            float minDist = Mathf.Infinity;
            Waypoint closest = null;

            foreach (var wp in list)
            {
                float distance = Vector3.Distance(from, wp.transform.position);
                if (distance < minDist)
                {
                    minDist = distance;
                    closest = wp;
                }
            }

            return closest;
        }
    }
}
