using UnityEngine;
using UnityEditor;
using System;

public class StringPopupWindow : EditorWindow
{
    private string inputText = "";
    private Action<string> onConfirm;

    public static void Show(string title, Action<string> onConfirm)
    {
        // Crea una piccola finestra modale
        StringPopupWindow window = CreateInstance<StringPopupWindow>();
        window.titleContent = new GUIContent(title);
        window.onConfirm = onConfirm;

        // Mostra come Utility Window (piccola e senza tab)
        window.ShowUtility();

        // Imposta dimensioni minime
        window.minSize = new Vector2(250, 100);
        window.maxSize = new Vector2(250, 100);
    }

    private void OnGUI()
    {
        GUILayout.Label("Dai un nome al nuovo percorso: ", EditorStyles.boldLabel);
        inputText = EditorGUILayout.TextField(inputText);

        GUILayout.Space(10);
        GUILayout.BeginHorizontal();

        if (GUILayout.Button("OK"))
        {
            onConfirm?.Invoke(inputText);
            Close();
        }

        if (GUILayout.Button("Annulla"))
        {
            Close();
        }

        GUILayout.EndHorizontal();
    }
}
